<?php
require_once 'config/database.php';
require_once 'includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_SESSION['user_id'];
    $service_id = intval($_POST['service_id']);
    $quantity = intval($_POST['quantity']);
    
    if ($quantity < 10 || $quantity > 1000) {
        $_SESSION['error'] = "Quantity must be between 10 and 1000";
        redirect('dashboard.php');
    }
    
    // In real system, you would process payment here
    // For demo, we'll just assign emails
    
    $result = assignEmailsToUser($user_id, $service_id, $quantity);
    
    if ($result['success']) {
        $_SESSION['success'] = "Successfully purchased $quantity emails!";
    } else {
        $_SESSION['error'] = $result['message'];
    }
    
    redirect('dashboard.php');
}