<?php
require_once 'config/database.php';

// Test database connection
echo "<!DOCTYPE html>
<html>
<head>
    <title>Test Database Connection</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        pre { background: #f5f5f5; padding: 10px; }
    </style>
</head>
<body>
    <h1>Database Connection Test</h1>";

// Test 1: Basic connection
echo "<h2>Test 1: Basic Connection</h2>";
if (testDBConnection()) {
    echo "<p class='success'>✓ Database connection successful!</p>";
    
    // Test 2: Show databases
    echo "<h2>Test 2: Available Databases</h2>";
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
        $result = $conn->query("SHOW DATABASES");
        
        echo "<ul>";
        while ($row = $result->fetch_array()) {
            $db_name = $row[0];
            $selected = ($db_name == DB_NAME) ? " <strong>(Selected)</strong>" : "";
            echo "<li>{$db_name}{$selected}</li>";
        }
        echo "</ul>";
        
        $conn->close();
    } catch (Exception $e) {
        echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
    }
    
    // Test 3: Show tables
    echo "<h2>Test 3: Tables in Database</h2>";
    try {
        $db = getDB();
        $result = $db->query("SHOW TABLES");
        
        if ($result->num_rows > 0) {
            echo "<ul>";
            while ($row = $result->fetch_array()) {
                $table = $row[0];
                echo "<li>{$table}</li>";
            }
            echo "</ul>";
        } else {
            echo "<p class='info'>No tables found. You need to create them.</p>";
            echo "<a href='setup-database.php' class='button'>Go to Setup</a>";
        }
        
        $db->close();
    } catch (Exception $e) {
        echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
    }
    
} else {
    echo "<p class='error'>✗ Database connection failed</p>";
    echo "<p>Please check:</p>";
    echo "<ol>
        <li>Database credentials in config/database.php</li>
        <li>Database exists in CPanel</li>
        <li>User has proper permissions</li>
    </ol>";
}

echo "<h2>Current Configuration</h2>";
echo "<pre>";
echo "DB_HOST: " . DB_HOST . "\n";
echo "DB_USER: " . DB_USER . "\n";
echo "DB_NAME: " . DB_NAME . "\n";
echo "SITE_URL: " . SITE_URL . "\n";
echo "</pre>";

echo "<h2>Troubleshooting</h2>";
echo "<p>If connection fails, try:</p>";
echo "<ol>
    <li><a href='setup-database.php'>Run Setup Wizard</a></li>
    <li>Check database name in CPanel (should be like 'skprotik_email_service')</li>
    <li>Check username (should be like 'skprotik_d1')</li>
    <li>Reset password in CPanel MySQL Databases</li>
    <li>Try with IP address: '127.0.0.1' instead of 'localhost'</li>
</ol>";

echo "</body></html>";
?>