<?php
require_once 'config/database.php';
require_once 'includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $_SESSION['user_id'];
$email_id = intval($data['email_id']);
$service_name = sanitize($data['service_name']);

$result = useEmailForService($user_id, $email_id, $service_name);
echo json_encode($result);